// Plugin  change Menu

	(function(){

	//初始化建立
		Scene_Menu.prototype.create = function() {
	    	Scene_MenuBase.prototype.create.call(this);
	    	this.createCommandWindow();
	    	this.createCommamdImages();
	   };
	//建立圖片化選項
	Scene_Menu.prototype.createCommamdImages = function(){

		this._itemButton = new Sprite();
		this._itemButton.x = 375;
		this._itemButton.y = 130;

		this._loadButton = new Sprite();
		this._loadButton.x = 375;
		this._loadButton.y = 180;

		this._optionsButton = new Sprite();
		this._optionsButton.x = 375;
		this._optionsButton.y = 230;

		this._endButton = new Sprite();
		this._endButton.x = 375;
		this._endButton.y = 280;

		this.addChild( this._itemButton );
		this.addChild( this._loadButton );
		this.addChild( this._optionsButton );
		this.addChild( this._endButton );


	}
	//更新菜單圖片變化
	Scene_Menu.prototype.update = function(){

		//將菜單的預設控制選擇載入
		Scene_MenuBase.prototype.update.call(this);

		//控制圖片切換樣式
		switch ( this._commandWindow._index ){

			//物品
			case 0:
				this._itemButton.bitmap = ImageManager.loadPicture('menuBtn_01');
				this._loadButton.bitmap = ImageManager.loadPicture('menuBtn_03o');
				this._optionsButton.bitmap = ImageManager.loadPicture('menuBtn_04o');
				this._endButton.bitmap = ImageManager.loadPicture('menuBtn_05o');
				break;

				//讀檔
			case 1:
				this._itemButton.bitmap = ImageManager.loadPicture('menuBtn_01o');
				this._loadButton.bitmap = ImageManager.loadPicture('menuBtn_03');
				this._optionsButton.bitmap = ImageManager.loadPicture('menuBtn_04o');
				this._endButton.bitmap = ImageManager.loadPicture('menuBtn_05o');
				break;
				
				//選項
			case 2:
				this._itemButton.bitmap = ImageManager.loadPicture('menuBtn_01o');
				this._loadButton.bitmap = ImageManager.loadPicture('menuBtn_03o');
				this._optionsButton.bitmap = ImageManager.loadPicture('menuBtn_04');
				this._endButton.bitmap = ImageManager.loadPicture('menuBtn_05o');
				break;

				//離開
			case 3:
				this._itemButton.bitmap = ImageManager.loadPicture('menuBtn_01o');
				this._loadButton.bitmap = ImageManager.loadPicture('menuBtn_03o');
				this._optionsButton.bitmap = ImageManager.loadPicture('menuBtn_04o');
				this._endButton.bitmap = ImageManager.loadPicture('menuBtn_05');
				break;
				


		}

	}

	   Scene_Menu.prototype.start = function() {
	   		Scene_MenuBase.prototype.start.call(this);
	};

	//菜單功能綁定
	Scene_Menu.prototype.createCommandWindow = function() {
	    this._commandWindow = new Window_MenuCommand(0, 0);

	    this._commandWindow.visible = false; //隱藏預設菜單
	    this._commandWindow.x = Graphics.boxWidth;
	    this._commandWindow.y = Graphics.boxHeight;

	    this._commandWindow.setHandler('item',      this.commandItem.bind(this));
	    this._commandWindow.setHandler('load',   this.commandLoad.bind(this));
	    this._commandWindow.setHandler('options',      this.commandOptions.bind(this));
	    this._commandWindow.setHandler('gameEnd',   this.commandGameEnd.bind(this));
	    this._commandWindow.setHandler('cancel',    this.popScene.bind(this));
	    this.addWindow(this._commandWindow);
	};

	//新增一個讀取功能
	Scene_Menu.prototype.commandLoad = function(){
		SceneManager.push( Scene_Load );
	}

	Window_MenuCommand.prototype.addMainCommands = function() {
		var enabled = this.areMainCommandsEnabled();
		if (this.needsCommand('item')) {
		    this.addCommand(TextManager.item, 'item', enabled);
		}
	};

	//建立菜單背景
	Scene_MenuBase.prototype.createBackground = function() {
	    this._backgroundSprite = new Sprite();

	    //物品功能背景

	    if( SceneManager._scene instanceof Scene_Item ){

	    	this._backgroundSprite.bitmap = ImageManager.loadTitle1('選單');

		//讀檔功能背景

	    }else if( SceneManager._scene instanceof Scene_Load ){

	    	this._backgroundSprite.bitmap = ImageManager.loadTitle1('選單');

		//選項功能背景

	    }else if( SceneManager._scene instanceof Scene_Options ){

	    	this._backgroundSprite.bitmap = ImageManager.loadTitle1('選單');

		//離開功能背景

	    }else if( SceneManager._scene instanceof Scene_GameEnd ){

	    	this._backgroundSprite.bitmap = ImageManager.loadTitle1('選單');

	    //菜單起始背景
	    }else{

		    this._backgroundSprite.bitmap = ImageManager.loadTitle1('選單');
		}

	    this.addChild(this._backgroundSprite);
	};

	Window_MenuCommand.prototype.makeCommandList = function() {
		this.addMainCommands();
		this.addLoadCommand();
		this.addOptionsCommand();
		this.addGameEndCommand();
	};

	Window_MenuCommand.prototype.addLoadCommand = function(){
		this.addCommand( '讀取進度', 'load', true );
	}
})();